/*jslint vars: true, plusplus: true, devel: true, nomen: true, regexp: true, indent: 4, maxerr: 50 */
/*global $, window, location, CSInterface, SystemPath, themeManager*/

(function () {
    'use strict';

    var csInterface = new CSInterface();
        
    // Reloads extension panel
    function reloadPanel() {
        location.reload();
    }
    
    
    function init() {
                
        themeManager.init();
        
        $("#btn_reload").click(reloadPanel);
        
        $('.numbersOnly').keyup(function () {
            if (this.value != this.value.replace(/[^0-9\.]/g, '')) {
            this.value = this.value.replace(/[^0-9\.]/g, '');
            }
        });
        
        
        $("#dupBtn").click(function () {
            var copies = $("#copies").val();
            var moveX = $("#moveX").val();
            var moveY = $("#moveY").val();
                
            csInterface.evalScript('duplicator(' + copies + ' ,' + moveX + ' ,' + moveY + ')');
        });
        
        $(document).keypress(function(e) {
            if(e.which == 13) {
                var copies = $("#copies").val();
                var moveX = $("#moveX").val();
                var moveY = $("#moveY").val();

                csInterface.evalScript('duplicator(' + copies + ' ,' + moveX + ' ,' + moveY + ')');
            }
        });
    
    }
        
    init();

}());
    
